﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.SecuRadClt;
namespace radclt_test
{
    public class SecuRadDemo
    {
        public static void usage()
        {
            Console.WriteLine("Usage:UniOTP_Clt_Test.exe AuthHost ShareSecret Username OTP[PIN] Port Maxwaittime");
        }
        public static int Main(string []args)
        {
            if (args.Length < 4)
            {
                usage();
                return 0;
            }
            int nPort = 1812;
            if (args.Length >= 5)
            {
                nPort = Convert.ToUInt16(args[4]);
            }
            Console.WriteLine("start authentication test here!................");
            //construct a new SecuRadClts_Client Object
            //arguments:hostip  share   username    password(OTP or OTP+PIN depends on user's choice)   port
            SecuRadClts_Client securadclt = new SecuRadClts_Client(args[0], args[1], args[2], args[3], nPort);
            if (args.Length == 6)
            {
                securadclt.UDPTimeout = Convert.ToInt32(args[5]);
            }
            //set securadclt.Debug to true to generate debug information
            //securadclt.Debug = true;
            /*
             * Authebticate return code as follow:
                 0: "Authentication succeed"
                -1:  "Communication trouble. Is the server reachable? Maybe the shared secret is wrong";                    
                -2:  "Communication trouble. The remote host refused the connection (maybe a timeout)";
                -3:  "Paket length from the server is too small. Minimum is 20 bytes";
                -4:  "The server rejected your authentication request";
                -5:  "The response identifier does not match the request identifier";
                -6: "The paket length from the server is incorrect";
                -7: "invalid challenge information.";
                -8: "invalid package.";
               100: "challenge response!";
             */
            int retcode = securadclt.Authenticate();
            if (0 == retcode)
            {
                Console.WriteLine("Authentication successfully!!");
            }
            else if (100 == retcode)
            {
                Console.WriteLine(securadclt.pChallenge);
            }
            else//user Utils.Code2Message to get detail information
            {
                Console.WriteLine(System.Net.SecuRadClt.SecuRadClts_Client.Code2Message(retcode));
            }
            return 1;
        }
    }
}
